/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.jabcproject.handlers;

import de.jabc.cinco.meta.core.jabcproject.Activator;
import de.jabc.cinco.meta.core.jabcproject.TransEM4SIBGenerator;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.Manifest;
import mgl.MGLModel;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class CincoSIBGenerationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFile file = Activator.getDefault().getSelectionListener().getCurrentMGLFile();
        if (file != null && file.getFileExtension().equals("mgl")) {
            try {
                IPath modelPath = file.getLocation();
                this.prepareProject(file.getProject());
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource mglResource = resourceSet.createResource(URI.createFileURI((String)modelPath.toFile().getAbsolutePath()));
                mglResource.load(null);
                MGLModel mglModel = (MGLModel)mglResource.getContents().get(0);
                new TransEM4SIBGenerator(file.getProject(), mglModel).run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void prepareProject(IProject project) {
        Manifest mani = new Manifest();
        try {
            mani.read(new FileInputStream(project.getLocation().append("META-INF/MANIFEST.MF").toFile()));
            String oldValue = mani.getMainAttributes().getValue("Require-Bundle");
            if (!oldValue.contains("de.jabc.cinco.meta.libraries")) {
                oldValue = oldValue.concat(",de.jabc.cinco.meta.libraries");
                mani.getMainAttributes().putValue("Require-Bundle", oldValue);
            }
            if (!oldValue.contains("org.eclipse.xtend.typesystem.emf")) {
                oldValue = oldValue.concat(",org.eclipse.xtend.typesystem.emf");
                mani.getMainAttributes().putValue("Require-Bundle", oldValue);
            }
            if (!oldValue.contains("org.eclipse.emf.ecore.xmi")) {
                oldValue = oldValue.concat(",org.eclipse.emf.ecore.xmi");
                mani.getMainAttributes().putValue("Require-Bundle", oldValue);
            }
            if (!oldValue.contains("de.jabc.cinco.meta.core.sibgenerator")) {
                oldValue.concat("de.jabc.cinco.meta.core.sibgenerator");
                mani.getMainAttributes().putValue("Require-Bundle", oldValue);
            }
            mani.write(new FileOutputStream(project.getLocation().append("META-INF/MANIFEST.MF").toFile()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

