/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.mgl.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.mgl.validation.AbstractMGLValidator;
import de.jabc.cinco.meta.core.utils.CincoUtil;
import de.jabc.cinco.meta.core.utils.InheritanceUtil;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.PathValidator;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.runtime.xapi.FileExtension;
import de.jabc.cinco.meta.runtime.xapi.WorkspaceExtension;
import de.jabc.cinco.meta.util.DirectedGraph;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.Manifest;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.Attribute;
import mgl.BoundedConstraint;
import mgl.ComplexAttribute;
import mgl.ContainingElement;
import mgl.DefaultValueOverride;
import mgl.Edge;
import mgl.GraphModel;
import mgl.GraphicalElementContainment;
import mgl.GraphicalModelElement;
import mgl.Import;
import mgl.IncomingEdgeElementConnection;
import mgl.MGLModel;
import mgl.MglPackage;
import mgl.ModelElement;
import mgl.Node;
import mgl.NodeContainer;
import mgl.OutgoingEdgeElementConnection;
import mgl.PrimitiveAttribute;
import mgl.ReferencedEClass;
import mgl.ReferencedType;
import mgl.Type;
import mgl.UserDefinedType;
import mgl.Wildcard;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import productDefinition.CincoProduct;
import productDefinition.MGLDescriptor;

public class MGLValidator
extends AbstractMGLValidator {
    @Extension
    private FileExtension _fileExtension = new FileExtension();
    @Extension
    private InheritanceUtil _inheritanceUtil = new InheritanceUtil();
    @Extension
    private WorkspaceExtension _workspaceExtension = new WorkspaceExtension();
    public static final String NOT_EXPORTED = "package is not exported";

    @Check
    public void checkPackageNameExists(MGLModel model) {
        if (StringExtensions.isNullOrEmpty((String)model.getPackage()) || Objects.equal((Object)model.getPackage(), (Object)"\"\"")) {
            this.error("Package name must be present.", (EStructuralFeature)MglPackage.Literals.MGL_MODEL__PACKAGE);
        }
    }

    @Check
    public void checkNamedElementNameStartsWithCapital(ModelElement namedElement) {
        boolean _not;
        boolean _isUpperCase = Character.isUpperCase(namedElement.getName().charAt(0));
        boolean bl = _not = !_isUpperCase;
        if (_not) {
            this.error("Name must start with a capital", (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
        }
    }

    @Check
    public void checkNamedElementNameNotUnique(ModelElement namedElement) {
        Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)namedElement.eContainer().eAllContents()), ModelElement.class);
        for (ModelElement e : _filter) {
            if (!Objects.equal((Object)e.getName(), (Object)namedElement.getName()) || Objects.equal((Object)e, (Object)namedElement)) continue;
            this.error("Name must be unique", (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
        }
    }

    @Check
    public void checkNodeIncomingConnections(GraphicalModelElement elem) {
        boolean _lessThan;
        int _length = ((Object[])Conversions.unwrapArray((Object)elem.getIncomingEdgeConnections(), Object.class)).length;
        boolean bl = _lessThan = _length < 2;
        if (_lessThan) {
            return;
        }
        EList _incomingEdgeConnections = elem.getIncomingEdgeConnections();
        for (IncomingEdgeElementConnection connection : _incomingEdgeConnections) {
            boolean _tripleEquals;
            EList _connectingEdges = connection.getConnectingEdges();
            boolean bl2 = _tripleEquals = _connectingEdges == null;
            if (!_tripleEquals) continue;
            this.error("Incoming Edges cannot have a don't care and other edges.", (EStructuralFeature)MglPackage.Literals.GRAPHICAL_MODEL_ELEMENT__INCOMING_EDGE_CONNECTIONS);
        }
    }

    @Check
    public void checkNodeOutgoingConnections(GraphicalModelElement elem) {
        boolean _lessThan;
        int _length = ((Object[])Conversions.unwrapArray((Object)elem.getOutgoingEdgeConnections(), Object.class)).length;
        boolean bl = _lessThan = _length < 2;
        if (_lessThan) {
            return;
        }
        EList _outgoingEdgeConnections = elem.getOutgoingEdgeConnections();
        for (OutgoingEdgeElementConnection connection : _outgoingEdgeConnections) {
            boolean _tripleEquals;
            EList _connectingEdges = connection.getConnectingEdges();
            boolean bl2 = _tripleEquals = _connectingEdges == null;
            if (!_tripleEquals) continue;
            this.error("Incoming Edges cannot have a don't care and other edges.", (EStructuralFeature)MglPackage.Literals.GRAPHICAL_MODEL_ELEMENT__OUTGOING_EDGE_CONNECTIONS);
        }
    }

    @Check
    public void checkIncomingEdgeConnectionsUnique(GraphicalModelElement elem) {
        HashSet set = CollectionLiterals.newHashSet();
        EList _incomingEdgeConnections = elem.getIncomingEdgeConnections();
        for (IncomingEdgeElementConnection connection : _incomingEdgeConnections) {
            if (connection.getConnectingEdges() == null || set.add(connection.getConnectingEdges())) continue;
            this.error("Given Edges should be unique", (EStructuralFeature)MglPackage.Literals.GRAPHICAL_MODEL_ELEMENT__INCOMING_EDGE_CONNECTIONS);
        }
    }

    @Check
    public void checkOutgoingEdgeConnectionsUnique(GraphicalModelElement elem) {
        HashSet set = CollectionLiterals.newHashSet();
        EList _outgoingEdgeConnections = elem.getOutgoingEdgeConnections();
        for (OutgoingEdgeElementConnection connection : _outgoingEdgeConnections) {
            if (connection.getConnectingEdges() == null || set.add(connection.getConnectingEdges())) continue;
            this.error("Given Edges should be unique", (EStructuralFeature)MglPackage.Literals.GRAPHICAL_MODEL_ELEMENT__OUTGOING_EDGE_CONNECTIONS);
        }
    }

    @Check
    public void checkUpperBound(Attribute attribute) {
        if (attribute.getUpperBound() == 0 || attribute.getUpperBound() < -1) {
            String _name = attribute.getName();
            String _plus = "Upper Bound of attribute " + _name;
            String _plus_1 = String.valueOf(_plus) + " must be -1 or bigger than 0";
            this.error(_plus_1, (EStructuralFeature)MglPackage.Literals.ATTRIBUTE__UPPER_BOUND);
        }
        if (attribute.getUpperBound().compareTo(attribute.getLowerBound()) < 0 && attribute.getUpperBound() != -1) {
            String _name_1 = attribute.getName();
            String _plus_2 = "Upper Bound of attribute " + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + " can not be lower than Lower Bound";
            this.error(_plus_3, (EStructuralFeature)MglPackage.Literals.ATTRIBUTE__UPPER_BOUND);
        }
    }

    @Check
    public void checkLowerBound(Attribute attribute) {
        boolean _lessThan;
        Integer _lowerBound = attribute.getLowerBound();
        boolean bl = _lessThan = _lowerBound < 0;
        if (_lessThan) {
            String _name = attribute.getName();
            String _plus = "Lower Bound of attribute " + _name;
            String _plus_1 = String.valueOf(_plus) + " cannot be lower than 0.";
            this.error(_plus_1, (EStructuralFeature)MglPackage.Literals.ATTRIBUTE__LOWER_BOUND);
        }
        if (attribute.getLowerBound().compareTo(attribute.getUpperBound()) > 0 && attribute.getUpperBound() != -1) {
            String _name_1 = attribute.getName();
            String _plus_2 = "Lower Bound of attribute " + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + " cannot be larger than Upper Bound.";
            this.error(_plus_3, (EStructuralFeature)MglPackage.Literals.ATTRIBUTE__LOWER_BOUND);
        }
    }

    @Check
    public void checkReservedWordsInAttributes(Attribute attr) {
        String _upperCase = attr.getName().toUpperCase();
        boolean _equals = Objects.equal((Object)_upperCase, (Object)"ID");
        if (_equals) {
            String _name = attr.getName();
            String _plus = "Attribute Name cannot be " + _name;
            String _plus_1 = String.valueOf(_plus) + ".";
            this.error(_plus_1, (EStructuralFeature)MglPackage.Literals.ATTRIBUTE__NAME);
        }
    }

    @Check
    public void checkFeatureNameUnique(Attribute attr) {
        EList _attributes = attr.getModelElement().getAttributes();
        for (Attribute a : _attributes) {
            if (Objects.equal((Object)a, (Object)attr) || !a.getName().equalsIgnoreCase(attr.getName())) continue;
            this.error("Attribute Names must be unique", (EStructuralFeature)MglPackage.Literals.ATTRIBUTE__NAME);
        }
        ModelElement container = attr.getModelElement();
        if (container instanceof Node) {
            boolean _tripleNotEquals;
            ReferencedType _primeReference = ((Node)container).getPrimeReference();
            boolean bl = _tripleNotEquals = _primeReference != null;
            if (_tripleNotEquals) {
                String name = ((Node)container).getPrimeReference().getName();
                boolean _equalsIgnoreCase = attr.getName().equalsIgnoreCase(name);
                if (_equalsIgnoreCase) {
                    this.error("Attribute Names must be different from Prime Reference Names", (EStructuralFeature)MglPackage.Literals.ATTRIBUTE__NAME);
                }
            }
        }
        ModelElement element = attr.getModelElement();
        ModelElement superType = MGLValidator.getExtends(element);
        while (superType != null && IterableExtensions.isNullOrEmpty((Iterable)this._inheritanceUtil.checkMGLInheritance(element))) {
            EList _attributes_1 = superType.getAttributes();
            for (Attribute a_1 : _attributes_1) {
                boolean _equalsIgnoreCase_1 = a_1.getName().equalsIgnoreCase(attr.getName());
                if (!_equalsIgnoreCase_1 || attr instanceof ComplexAttribute && ((ComplexAttribute)attr).isOverride()) continue;
                this.error("Attribute Names must be unique", (EStructuralFeature)MglPackage.Literals.ATTRIBUTE__NAME);
            }
            superType = MGLValidator.getExtends(superType);
        }
    }

    @Check
    public void checkIsOverridenTypeSuperType(final ComplexAttribute attr) {
        ModelElement e = MGLValidator.getExtends(MGLValidator.parent(attr));
        while (e != null) {
            Consumer<ComplexAttribute> _function = new Consumer<ComplexAttribute>(){

                @Override
                public void accept(ComplexAttribute at) {
                    if (Objects.equal((Object)at.getName(), (Object)attr.getName()) && !MGLValidator.isSubType(attr.getType(), at.getType())) {
                        MGLValidator.this.error("Overriding attribute types must be subtype of overridden attribute types.", (EStructuralFeature)MglPackage.Literals.COMPLEX_ATTRIBUTE__TYPE);
                    }
                }
            };
            Iterables.filter((Iterable)e.getAttributes(), ComplexAttribute.class).forEach(_function);
            Consumer<PrimitiveAttribute> _function_1 = new Consumer<PrimitiveAttribute>(){

                @Override
                public void accept(PrimitiveAttribute at) {
                    String _name_1;
                    String _name = at.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = attr.getName()));
                    if (_equals) {
                        MGLValidator.this.error("Only Complex Attributes can be overridden.", (EStructuralFeature)MglPackage.Literals.COMPLEX_ATTRIBUTE__TYPE);
                    }
                }
            };
            Iterables.filter((Iterable)e.getAttributes(), PrimitiveAttribute.class).forEach(_function_1);
            e = MGLValidator.getExtends(e);
        }
    }

    public static boolean isSubType(Type subtype, Type superType) {
        if (subtype instanceof ModelElement && superType instanceof ModelElement) {
            ModelElement e = MGLValidator.getExtends((ModelElement)subtype);
            while (e != null) {
                boolean _equals = Objects.equal((Object)e, (Object)superType);
                if (_equals) {
                    return true;
                }
                e = MGLValidator.getExtends(e);
            }
        }
        return false;
    }

    private static ModelElement parent(ComplexAttribute attribute) {
        EObject _eContainer = attribute.eContainer();
        return (ModelElement)_eContainer;
    }

    private static <T extends ModelElement> ModelElement getExtends(ModelElement element) {
        Node _switchResult = null;
        boolean _matched = false;
        if (element instanceof Node) {
            _matched = true;
            _switchResult = ((Node)element).getExtends();
        }
        if (!_matched && element instanceof Edge) {
            _matched = true;
            _switchResult = ((Edge)element).getExtends();
        }
        if (!_matched && element instanceof UserDefinedType) {
            _matched = true;
            _switchResult = ((UserDefinedType)element).getExtends();
        }
        if (!_matched && element instanceof GraphModel) {
            _matched = true;
            _switchResult = ((GraphModel)element).getExtends();
        }
        return _switchResult;
    }

    @Check
    public void checkCanResolveEClass(ReferencedEClass ref) {
        EClass eclass = ref.getType();
        boolean _eIsProxy = eclass.eIsProxy();
        if (_eIsProxy) {
            try {
                EObject obj = null;
                EObject _resolve = EcoreUtil2.resolve((EObject)eclass, obj);
                ref.setType((EClass)_resolve);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    this.error("Cannot resolve EClass: " + eclass, (EStructuralFeature)MglPackage.Literals.REFERENCED_ECLASS__TYPE);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    @Check
    public void checkNodeInheritsFromNonAbstractPrimeReferenceNode(Node node) {
        Node currentNode = node;
        boolean noCircles = IterableExtensions.isNullOrEmpty((Iterable)this._inheritanceUtil.checkMGLInheritance((ModelElement)node));
        while (currentNode.getExtends() != null && noCircles) {
            if ((currentNode = currentNode.getExtends()).isIsAbstract() || !(currentNode instanceof ReferencedType)) continue;
            String _name = node.getName();
            String _plus = "Node " + _name;
            String _plus_1 = String.valueOf(_plus) + " inherits from non abstract prime node ";
            String _name_1 = currentNode.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            this.error(_plus_2, (EStructuralFeature)MglPackage.Literals.NODE__EXTENDS);
        }
    }

    @Check
    public void checkNodeInheritsFromNonAbstractNodeWithPrimeReferenceAttribute(Node node) {
        Node parentNode = node.getExtends();
        if (node.getPrimeReference() != null && parentNode != null && MGLUtil.isPrime((Node)parentNode)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Nodes extending prime nodes may not override the prime reference");
            this.error(_builder.toString(), (EStructuralFeature)MglPackage.Literals.NODE__PRIME_REFERENCE);
        }
    }

    @Check
    public void checkGraphicalModelElementUsesStyleAttribute(GraphicalModelElement graphicalModelElement) {
        if (!graphicalModelElement.isIsAbstract() && (graphicalModelElement.getUsedStyle() == null || graphicalModelElement.getUsedStyle().isEmpty())) {
            this.error("Non-abstract Graphical Model Elements have to reference a style.", (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
        }
    }

    @Check
    public void checkAbstractGraphicalModelElementHasUselessStyleAttributes(GraphicalModelElement graphicalModelElement) {
        if (graphicalModelElement.isIsAbstract() && graphicalModelElement.getUsedStyle() != null) {
            this.warning("Referencing styles has no effect on abstract elements", (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
        }
        if (graphicalModelElement.isIsAbstract() && IterableExtensions.exists((Iterable)graphicalModelElement.getAnnotations(), (Functions.Function1)new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation x) {
                return x.getName().equals("icon");
            }
        })) {
            this.warning("@icon annotation has no effect on abstract elements", (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
        }
        if (graphicalModelElement.isIsAbstract() && IterableExtensions.exists((Iterable)graphicalModelElement.getAnnotations(), (Functions.Function1)new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation x) {
                return x.getName().equals("palette");
            }
        })) {
            this.warning("@palette annotation has no effect on abstract elements", (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
        }
    }

    @Check
    public void checkGraphModelContainableElements(ContainingElement model) {
        int _size_1;
        boolean _equals;
        boolean _greaterThan;
        int _size = model.getContainableElements().size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            EList _containableElements = model.getContainableElements();
            for (GraphicalElementContainment containment : _containableElements) {
                boolean _tripleEquals;
                EList _types = containment.getTypes();
                boolean bl2 = _tripleEquals = _types == null;
                if (!_tripleEquals) continue;
                this.error("Dont't care type must not be accompanied by other containable elements.", (EStructuralFeature)MglPackage.Literals.CONTAINING_ELEMENT__CONTAINABLE_ELEMENTS);
            }
        }
        boolean bl3 = _equals = (_size_1 = model.getContainableElements().size()) == 1;
        if (_equals) {
            boolean _tripleEquals_1;
            EList _types_1 = ((GraphicalElementContainment)model.getContainableElements().get(0)).getTypes();
            boolean bl4 = _tripleEquals_1 = _types_1 == null;
            if (_tripleEquals_1) {
                boolean _equals_1;
                int _upperBound = ((GraphicalElementContainment)model.getContainableElements().get(0)).getUpperBound();
                boolean bl5 = _equals_1 = _upperBound == 0;
                if (_equals_1) {
                    this.warning("Container element cannot contain any model elements by this definition.", (EStructuralFeature)MglPackage.Literals.CONTAINING_ELEMENT__CONTAINABLE_ELEMENTS);
                }
            }
        }
    }

    @Check
    public void checkBoundedConstraintCardinality(BoundedConstraint bc) {
        int lower = bc.getLowerBound();
        int upper = bc.getUpperBound();
        if (lower < 0) {
            this.error("Containment lower bound must not be lower 0.", (EStructuralFeature)MglPackage.Literals.BOUNDED_CONSTRAINT__LOWER_BOUND);
        }
        if (lower > upper && upper != -1) {
            this.error("Containment lower bound must not be bigger than upper bound.", (EStructuralFeature)MglPackage.Literals.BOUNDED_CONSTRAINT__LOWER_BOUND);
        }
        if (upper < -1) {
            this.error("Containment upper bound must not be lower -1", (EStructuralFeature)MglPackage.Literals.BOUNDED_CONSTRAINT__UPPER_BOUND);
        }
    }

    @Check
    public void checkDiagramExtensionisNotEmpty(GraphModel m) {
        if (!m.isIsAbstract() && StringExtensions.isNullOrEmpty((String)m.getFileExtension())) {
            this.error("Non-abstract graph models require a file extension.", (EStructuralFeature)MglPackage.Literals.GRAPH_MODEL__FILE_EXTENSION);
        }
    }

    @Check
    public void checkGraphModelIconPath(GraphModel gm) {
        boolean _not;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)gm.getIconPath());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            boolean _not_1;
            String _checkPath = PathValidator.checkPath((EObject)gm, (String)gm.getIconPath());
            String retVal = _checkPath;
            boolean _isEmpty = retVal.isEmpty();
            boolean bl2 = _not_1 = !_isEmpty;
            if (_not_1) {
                String _iconPath = gm.getIconPath();
                String _plus = "The specified path: \"" + _iconPath;
                String _plus_1 = String.valueOf(_plus) + "\" does not exist";
                this.error(retVal, (EStructuralFeature)MglPackage.Literals.GRAPH_MODEL__ICON_PATH, _plus_1, new String[0]);
            }
        }
    }

    @Check
    public void checkImportUris(Import imp) {
        try {
            boolean _not;
            String retVal = PathValidator.checkPath((EObject)imp, (String)imp.getImportURI());
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)retVal);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                this.error(retVal, (EStructuralFeature)MglPackage.Literals.IMPORT__IMPORT_URI, "Could not load resource", new String[0]);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                this.error("Could not load resource", (EStructuralFeature)MglPackage.Literals.IMPORT__IMPORT_URI, "Could not load resource", new String[0]);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Check
    public void checkExternalMGLIsStealth(Import imp) {
        boolean _not;
        boolean _isRelativePath = PathValidator.isRelativePath((String)imp.getImportURI());
        boolean bl = _not = !_isRelativePath;
        if (_not && !PathValidator.checkSameProjects((EObject)imp, (String)imp.getImportURI()) && this.isMglImport(imp.getImportURI()) && !imp.isStealth() && !imp.isExternal()) {
            this.error("MGLs imported from foreign Projects must be imported stealthy or be marked as an external import", (EStructuralFeature)MglPackage.Literals.IMPORT__IMPORT_URI);
        }
    }

    public boolean isMglImport(String importURI) {
        return importURI.endsWith(".mgl");
    }

    @Check
    public void checkMGLInheritanceCircles(ModelElement me) {
        boolean _not;
        List retvalList = this._inheritanceUtil.checkMGLInheritance(me);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)retvalList);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            if (me instanceof Node) {
                this.error("Cycle in inheritance caused by: " + retvalList, (EStructuralFeature)MglPackage.Literals.NODE__EXTENDS);
            }
            if (me instanceof Edge) {
                this.error("Cycle in inheritance caused by: " + retvalList, (EStructuralFeature)MglPackage.Literals.EDGE__EXTENDS);
            }
            if (me instanceof UserDefinedType) {
                this.error("Cycle in inheritance caused by: " + retvalList, (EStructuralFeature)MglPackage.Literals.USER_DEFINED_TYPE__EXTENDS);
            }
            if (me instanceof GraphModel) {
                this.error("Cycle in inheritance caused by: " + retvalList, (EStructuralFeature)MglPackage.Literals.GRAPH_MODEL__EXTENDS);
            }
        }
    }

    @Check
    public void checkNodeInheritsFromNode(Node node) {
        if (!(node instanceof NodeContainer) && node.getExtends() != null && node.getExtends() instanceof NodeContainer) {
            this.error("Inheriting from Containers is not possible for Nodes.", (EStructuralFeature)MglPackage.Literals.NODE__EXTENDS);
        }
    }

    @Check
    public void checkAttributeNameUnequalContainablePlurals(final Attribute attribute) {
        EObject attrEContainer = attribute.eContainer();
        if (attrEContainer instanceof ContainingElement && (IterableExtensions.exists((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filter((Iterable)((ContainingElement)attrEContainer).getContainableElements(), (Functions.Function1)new Functions.Function1<GraphicalElementContainment, Boolean>(){

            public Boolean apply(GraphicalElementContainment it) {
                int _upperBound = it.getUpperBound();
                return _upperBound != 0;
            }
        }), (Functions.Function1)new Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>>(){

            public EList<GraphicalModelElement> apply(GraphicalElementContainment it) {
                return it.getTypes();
            }
        }), (Functions.Function1)new Functions.Function1<GraphicalModelElement, Boolean>(){

            public Boolean apply(GraphicalModelElement it) {
                String _lowerCase = it.getName().toLowerCase();
                String _plus = String.valueOf(_lowerCase) + "s";
                String _lowerCase_1 = attribute.getName().toLowerCase();
                return Objects.equal((Object)_plus, (Object)_lowerCase_1);
            }
        }) || IterableExtensions.exists((Iterable)((ContainingElement)attrEContainer).getContainmentWildcards(), (Functions.Function1)new Functions.Function1<Wildcard, Boolean>(){

            public Boolean apply(Wildcard it) {
                int _upperBound = it.getUpperBound();
                return _upperBound != 0;
            }
        }) && IterableExtensions.exists((Iterable)((MGLModel)attrEContainer.eContainer()).getNodes(), (Functions.Function1)new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node it) {
                String _lowerCase = it.getName().toLowerCase();
                String _plus = String.valueOf(_lowerCase) + "s";
                String _lowerCase_1 = attribute.getName().toLowerCase();
                return Objects.equal((Object)_plus, (Object)_lowerCase_1);
            }
        }))) {
            this.error("Attribute names must not be equal to plurals of containable elements", (EStructuralFeature)MglPackage.Literals.ATTRIBUTE__NAME);
        }
    }

    @Check
    public void checkHasFinalDefaultValue(Attribute attr) {
        boolean _isNotChangeable = attr.isNotChangeable();
        if (_isNotChangeable && (attr.getDefaultValue() == null || Objects.equal((Object)attr.getDefaultValue(), (Object)""))) {
            this.error("Final Attribute must have a default value", (EStructuralFeature)MglPackage.Literals.ATTRIBUTE__NOT_CHANGEABLE);
        }
    }

    @Check
    public void checkIsPackageNameValidJavaPackageName(MGLModel it) {
        String[] splitPN;
        String[] stringArray = splitPN = it.getPackage().split("\\.");
        int n = splitPN.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            char[] ca = part.toCharArray();
            int i = 0;
            while (i < ca.length) {
                boolean _isJavaIdentifierPart;
                boolean _not_1;
                if (i == 0) {
                    boolean _not;
                    boolean _isJavaIdentifierStart = Character.isJavaIdentifierStart(ca[i]);
                    boolean bl = _not = !_isJavaIdentifierStart;
                    if (_not) {
                        char _get = ca[i];
                        String _plus = "Character " + Character.valueOf(_get);
                        String _plus_1 = String.valueOf(_plus) + " is no valid Java identifier start.";
                        this.error(_plus_1, (EStructuralFeature)MglPackage.Literals.MGL_MODEL__PACKAGE);
                    }
                }
                boolean bl = _not_1 = !(_isJavaIdentifierPart = Character.isJavaIdentifierPart(ca[i]));
                if (_not_1) {
                    char _get_1 = ca[i];
                    String _plus_2 = "Character " + Character.valueOf(_get_1);
                    String _plus_3 = String.valueOf(_plus_2) + " is no valid Java identifier part.";
                    this.error(_plus_3, (EStructuralFeature)MglPackage.Literals.MGL_MODEL__PACKAGE);
                }
                ++i;
            }
            ++n2;
        }
    }

    @Check
    public void checkReferencedNodeHasNameAttribute(final ComplexAttribute attribute) {
        ModelElement _modelElement;
        ModelElement modelElement = _modelElement = attribute.getModelElement();
        MGLModel graphModel = MGLUtil.mglModel((Object)modelElement);
        Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node n) {
                return n.getName().equals(attribute.getType());
            }
        };
        Iterable refNodes = IterableExtensions.filter((Iterable)graphModel.getNodes(), (Functions.Function1)_function);
        Functions.Function1<Edge, Boolean> _function_1 = new Functions.Function1<Edge, Boolean>(){

            public Boolean apply(Edge e) {
                return e.getName().equals(attribute.getType());
            }
        };
        Iterable refEdges = IterableExtensions.filter((Iterable)graphModel.getEdges(), (Functions.Function1)_function_1);
        if (!(IterableExtensions.isNullOrEmpty((Iterable)refNodes) && IterableExtensions.isNullOrEmpty((Iterable)refEdges) || this.nodesContainsName(refNodes) || this.edgesContainsName(refEdges))) {
            Functions.Function1<Node, String> _function_2 = new Functions.Function1<Node, String>(){

                public String apply(Node it) {
                    return it.getName();
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)refNodes, (Functions.Function1)_function_2);
            String _plus = "Add a String attribute \"name\" to the NodeType(s): " + _map;
            this.error(_plus, (EStructuralFeature)MglPackage.Literals.COMPLEX_ATTRIBUTE__TYPE);
        }
    }

    private boolean edgesContainsName(Iterable<Edge> edges) {
        ArrayList parentEdges = CollectionLiterals.newArrayList();
        Iterator<Edge> iterator = edges.iterator();
        while (iterator.hasNext()) {
            Edge e;
            Edge currentParent = e = iterator.next();
            while (currentParent != null) {
                parentEdges.add(currentParent);
                currentParent = currentParent.getExtends();
            }
        }
        Functions.Function1<Edge, Boolean> _function = new Functions.Function1<Edge, Boolean>(){

            public Boolean apply(Edge p) {
                Functions.Function1<Attribute, String> _function = new Functions.Function1<Attribute, String>(){

                    public String apply(Attribute it) {
                        return it.getName();
                    }
                };
                return ListExtensions.map((List)p.getAttributes(), (Functions.Function1)_function).contains("name");
            }
        };
        Iterable remainingParents = IterableExtensions.filter((Iterable)parentEdges, (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)remainingParents);
        return !_isEmpty;
    }

    private boolean nodesContainsName(Iterable<Node> nodes) {
        ArrayList parentNodes = CollectionLiterals.newArrayList();
        Iterator<Node> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            Node n;
            Node currentParent = n = iterator.next();
            while (currentParent != null) {
                parentNodes.add(currentParent);
                currentParent = currentParent.getExtends();
            }
        }
        Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

            public Boolean apply(Node p) {
                Functions.Function1<Attribute, String> _function = new Functions.Function1<Attribute, String>(){

                    public String apply(Attribute it) {
                        return it.getName();
                    }
                };
                return ListExtensions.map((List)p.getAttributes(), (Functions.Function1)_function).contains("name");
            }
        };
        Iterable remainingParents = IterableExtensions.filter((Iterable)parentNodes, (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)remainingParents);
        return !_isEmpty;
    }

    @Check
    public void checkContainableElementIsIndependent(final GraphicalElementContainment e) {
        ContainingElement superType = this.getContainingSuperType((EObject)e.getContainingElement());
        while (!Objects.equal((Object)superType, (Object)e.getContainingElement()) && superType != null && superType instanceof ContainingElement) {
            Functions.Function1<GraphicalElementContainment, Boolean> _function = new Functions.Function1<GraphicalElementContainment, Boolean>(){

                public Boolean apply(GraphicalElementContainment y) {
                    Functions.Function1<GraphicalModelElement, Boolean> _function = new Functions.Function1<GraphicalModelElement, Boolean>(){

                        public Boolean apply(GraphicalModelElement x) {
                            return e.getTypes().contains((Object)x);
                        }
                    };
                    return IterableExtensions.exists((Iterable)y.getTypes(), (Functions.Function1)_function);
                }
            };
            boolean _exists = IterableExtensions.exists((Iterable)superType.getContainableElements(), (Functions.Function1)_function);
            if (_exists) {
                this.error("Containment must be independent from inherited containments", (EStructuralFeature)MglPackage.Literals.GRAPHICAL_ELEMENT_CONTAINMENT__TYPES);
            }
            superType = this.getContainingSuperType((EObject)superType);
        }
    }

    private ContainingElement _getContainingSuperType(ContainingElement modelElement) {
        GraphModel _extends;
        GraphModel _switchResult = null;
        boolean _matched = false;
        if (modelElement instanceof GraphModel) {
            _matched = true;
            _switchResult = _extends = ((GraphModel)modelElement).getExtends();
        }
        if (!_matched && modelElement instanceof NodeContainer) {
            _matched = true;
            _extends = ((NodeContainer)modelElement).getExtends();
            _switchResult = (NodeContainer)_extends;
        }
        return (ContainingElement)_switchResult;
    }

    private ContainingElement _getContainingSuperType(Node modelElement) {
        return null;
    }

    @Check
    public void checkMultipleAnnotation(final Annotation annot) {
        EList elementAnnotations = annot.getParent().getAnnotations();
        if (IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)elementAnnotations, (Functions.Function1)new Functions.Function1<Annotation, Boolean>(){

            public Boolean apply(Annotation it) {
                String _name = it.getName();
                String _name_1 = annot.getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            }
        })) > 1 && !this.isMultipleAllowed(annot)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Multiple annotations of type: ");
            String _name = annot.getName();
            _builder.append(_name);
            this.error(_builder.toString(), (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
        }
    }

    public boolean isMultipleAllowed(Annotation annotation) {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"mcam_checkmodule", "contextMenuAction", "postDelete", "postCreate"})).contains(annotation.getName());
    }

    @Check
    public void checkCustomActionAnnotation(Annotation annotation) {
        boolean _isCustomAction = this.isCustomAction(annotation.getName());
        if (_isCustomAction) {
            if (IterableExtensions.isNullOrEmpty((Iterable)annotation.getValue()) || annotation.getValue().size() != 1) {
                this.error("CustomAction needs exactly one Java Class as a Parameter", (EStructuralFeature)MglPackage.Literals.ANNOTATION__VALUE);
            } else {
                String parameter = (String)annotation.getValue().get(0);
                boolean _isEmpty = parameter.isEmpty();
                if (_isEmpty) {
                    this.error("Java Class cannot be an empty String", (EStructuralFeature)MglPackage.Literals.ANNOTATION__VALUE);
                } else {
                    this.checkIfJavaClassExistsAndIsAccessible(parameter);
                }
            }
        }
    }

    private boolean isCustomAction(String name) {
        boolean _matched = false;
        if (Objects.equal((Object)name, (Object)"contextMenuAction")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)name, (Object)"doubleClickAction")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)name, (Object)"postSelect")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)name, (Object)"postCreate")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)name, (Object)"postMove")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)name, (Object)"postResize")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)name, (Object)"preDelete")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)name, (Object)"postDelete")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)name, (Object)"postSave")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)name, (Object)"postAttributeChange")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)name, (Object)"possibleValuesProvider")) {
            _matched = true;
        }
        return _matched;
    }

    private void checkIfJavaClassExistsAndIsAccessible(String fqClassName) {
        IType correctFile = this.findClass(fqClassName);
        if (correctFile == null || !correctFile.exists()) {
            this.error("Java Class does not exists", (EStructuralFeature)MglPackage.Literals.ANNOTATION__VALUE);
        } else {
            IJavaProject package_ = this.findPackage(fqClassName);
            if (package_ == null) {
                this.error("Package not found", (EStructuralFeature)MglPackage.Literals.ANNOTATION__VALUE);
            } else {
                this.checkIfPackageIsExported(correctFile, package_);
            }
        }
    }

    public IType findClass(String parameter) {
        IProject[] projects;
        IType javaClass = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IProject project = iProjectArray[n2];
                IJavaProject _create = JavaCore.create((IProject)project);
                IJavaProject jproject = _create;
                boolean _exists = jproject.exists();
                if (_exists) {
                    try {
                        javaClass = jproject.findType(parameter);
                        if (javaClass != null) {
                            return javaClass;
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) break block5;
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            }
            ++n2;
        }
        return javaClass;
    }

    public IJavaProject findPackage(String parameter) {
        IProject[] projects;
        IType javaClass = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IProject project = iProjectArray[n2];
                IJavaProject _create = JavaCore.create((IProject)project);
                IJavaProject jproject = _create;
                boolean _exists = jproject.exists();
                if (_exists) {
                    try {
                        javaClass = jproject.findType(parameter);
                        if (javaClass != null) {
                            return jproject;
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) break block5;
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    private void checkIfPackageIsExported(IType correctFile, IJavaProject package_) {
        IProject[] projects;
        String packageExport = correctFile.getPackageFragment().getElementName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isExported;
            IFolder folder;
            IFile manifest;
            boolean _exists;
            String _elementName;
            IProject project = iProjectArray[n2];
            String _name = project.getName();
            boolean _equals = Objects.equal((Object)_name, (Object)(_elementName = package_.getElementName()));
            if (_equals && (_exists = (manifest = (folder = project.getFolder("META-INF")).getFile("MANIFEST.MF")).exists()) && !(isExported = this.findExportedPackage(project, packageExport))) {
                this.warning("Corresponding package is not exported", (EStructuralFeature)MglPackage.Literals.ANNOTATION__VALUE, NOT_EXPORTED, new String[0]);
            }
            ++n2;
        }
    }

    public boolean findExportedPackage(IProject project, String packageName) {
        try {
            IFile iManiFile = project.getFolder("META-INF").getFile("MANIFEST.MF");
            CincoUtil.refreshFiles(null, (IFile[])new IFile[]{iManiFile});
            InputStream _contents = iManiFile.getContents();
            Manifest manifest = new Manifest(_contents);
            String value = manifest.getMainAttributes().getValue("Export-Package");
            if (value == null) {
                value = "";
            }
            return value.contains(packageName);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Check
    public void checkColorAnnotation(Annotation a) {
        boolean _equals_1;
        String _name = a.getName();
        boolean _equals = Objects.equal((Object)_name, (Object)"color");
        if (!_equals) return;
        int _size = a.getValue().size();
        boolean bl = _equals_1 = _size == 1;
        if (_equals_1) {
            Annotatable _parent = a.getParent();
            if (_parent instanceof PrimitiveAttribute) {
                String _get;
                boolean _notEquals;
                Annotatable _parent_1 = a.getParent();
                PrimitiveAttribute attr = (PrimitiveAttribute)_parent_1;
                String _name_1 = attr.getType().getName();
                boolean bl2 = _notEquals = !Objects.equal((Object)_name_1, (Object)"EString");
                if (_notEquals) {
                    this.error("Attribute type has to be EString", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
                }
                if (Objects.equal((Object)(_get = (String)a.getValue().get(0)), (Object)"")) {
                    return;
                }
                boolean bl3 = true;
                boolean _notEquals_1 = bl3;
                if (!_notEquals_1) return;
                String _get_1 = (String)a.getValue().get(0);
                boolean _equals_2 = Objects.equal((Object)_get_1, (Object)"rgb");
                if (_equals_2) {
                    String defaultValue;
                    String[] result;
                    String[] _converted_result;
                    int _size_1;
                    boolean _notEquals_2;
                    if (attr.getDefaultValue().isEmpty()) {
                        if (Objects.equal((Object)attr.getDefaultValue().isEmpty(), (Object)"")) return;
                    }
                    boolean bl4 = _notEquals_2 = (_size_1 = ((List)Conversions.doWrapArray((Object)(_converted_result = (result = (defaultValue = attr.getDefaultValue()).split(","))))).size()) != 3;
                    if (_notEquals_2) {
                        this.error("default value doesn't have a RGB-scheme", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
                        return;
                    } else {
                        this.checkRGBDefaultValues(result);
                    }
                    return;
                } else {
                    String _get_2 = (String)a.getValue().get(0);
                    boolean _equals_3 = Objects.equal((Object)_get_2, (Object)"hex");
                    if (_equals_3) {
                        String defaultValue_1;
                        int _length;
                        boolean _equals_4;
                        if (attr.getDefaultValue().isEmpty()) {
                            if (Objects.equal((Object)attr.getDefaultValue(), (Object)"")) return;
                        }
                        boolean bl5 = _equals_4 = (_length = (defaultValue_1 = attr.getDefaultValue()).length()) == 7;
                        if (_equals_4) {
                            boolean _startsWith = defaultValue_1.startsWith("#");
                            if (_startsWith) {
                                int i = 1;
                                while (i < defaultValue_1.length()) {
                                    char value = defaultValue_1.charAt(i);
                                    if (value < '0' || value > '9') {
                                        boolean _not;
                                        boolean _checkLetter = this.checkLetter(value);
                                        boolean bl6 = _not = !_checkLetter;
                                        if (_not) {
                                            this.error("hex values are between 0 and 9 or A and F", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
                                        }
                                    }
                                    ++i;
                                }
                                return;
                            } else {
                                this.error("default value of hex must start with '#'", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
                            }
                            return;
                        } else {
                            this.error("default value does not have a hex-scheme", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
                        }
                        return;
                    } else {
                        String _get_3 = (String)a.getValue().get(0);
                        boolean _equals_5 = Objects.equal((Object)_get_3, (Object)"rgba");
                        if (_equals_5) {
                            String defaultValue_2;
                            String[] result_1;
                            String[] _converted_result_1;
                            int _size_2;
                            boolean _notEquals_3;
                            if (attr.getDefaultValue().isEmpty()) {
                                if (Objects.equal((Object)attr.getDefaultValue().isEmpty(), (Object)"")) return;
                            }
                            boolean bl7 = _notEquals_3 = (_size_2 = ((List)Conversions.doWrapArray((Object)(_converted_result_1 = (result_1 = (defaultValue_2 = attr.getDefaultValue()).split(","))))).size()) != 4;
                            if (_notEquals_3) {
                                this.error("default value doesn't have a RGBA-scheme", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
                                return;
                            } else {
                                this.checkRGBDefaultValues(result_1);
                                String a_string = result_1[3];
                                try {
                                    int alpha = Integer.parseInt(a_string);
                                    if (alpha >= 0) {
                                        if (alpha <= 255) return;
                                    }
                                    this.error("alpha-value has to be bigger or equal than 0 and lower or equal than 255 ", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
                                    return;
                                }
                                catch (Throwable _t) {
                                    if (!(_t instanceof Exception)) throw Exceptions.sneakyThrow((Throwable)_t);
                                    this.error("Please enter only numbers as default value", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
                                    return;
                                }
                            }
                        } else {
                            this.error("color Annotation needs one parameter like rgb, rgba or hex", (EStructuralFeature)MglPackage.Literals.ANNOTATION__VALUE);
                        }
                    }
                }
                return;
            } else {
                this.error("Attribute has to be a PrimitiveAttribute ", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
            }
            return;
        } else {
            this.error("color Annotation needs exactly one parameter like rgb, hex or rgba", (EStructuralFeature)MglPackage.Literals.ANNOTATION__VALUE);
        }
    }

    private void checkRGBDefaultValues(String[] result) {
        String r_string = result[0];
        String g_string = result[1];
        String b_string = result[2];
        try {
            int r = Integer.parseInt(r_string);
            int g = Integer.parseInt(g_string);
            int b = Integer.parseInt(b_string);
            if (r < 0 || r > 255) {
                this.error("r-value has to be bigger or equal than 0 and lower or equal than 255", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
            }
            if (g < 0 || g > 255) {
                this.error("g-value has to be bigger or equal than 0 and lower or equal than 255", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
            }
            if (b < 0 || b > 255) {
                this.error("b-value has to be bigger or equal than 0 and lower or equal than 255", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                this.error("Please enter only numbers as default value", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private boolean checkLetter(char c) {
        String _string = Character.valueOf(c).toString();
        boolean _matched = false;
        if (Objects.equal((Object)_string, (Object)"A")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_string, (Object)"B")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_string, (Object)"C")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_string, (Object)"D")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_string, (Object)"E")) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)_string, (Object)"F")) {
            _matched = true;
        }
        return _matched;
    }

    @Check
    public void checkFileAnnotations(Annotation a) {
        if (Objects.equal((Object)a.getName(), (Object)"file") && a.getParent() instanceof PrimitiveAttribute) {
            boolean _notEquals;
            Annotatable _parent = a.getParent();
            PrimitiveAttribute attr = (PrimitiveAttribute)_parent;
            String _name = attr.getType().getName();
            boolean bl = _notEquals = !Objects.equal((Object)_name, (Object)"EString");
            if (_notEquals) {
                this.error("Type has to be EString", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
            }
            if (!attr.getDefaultValue().isEmpty() || !Objects.equal((Object)attr.getDefaultValue().isEmpty(), (Object)"")) {
                String defaultValue = attr.getDefaultValue();
                try {
                    boolean _not;
                    File file = new File(defaultValue);
                    boolean _exists = file.exists();
                    boolean bl2 = _not = !_exists;
                    if (_not) {
                        this.error("Wrong Path: File doesn't exists", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        this.error("Wrong Path: File doesn't exists", (EStructuralFeature)MglPackage.Literals.ANNOTATION__NAME);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
    }

    @Check
    public void checkImportCycleExists(Import imprt) {
        boolean _not;
        boolean _isStealth = imprt.isStealth();
        boolean bl = _not = !_isStealth;
        if (_not) {
            EObject _eContainer = imprt.eContainer();
            MGLModel originalMGLModel = (MGLModel)_eContainer;
            MGLModel importedMGLModel = CincoUtil.getImportedMGLModel((Import)imprt);
            if (importedMGLModel != null) {
                Functions.Function1<Import, Boolean> _function = new Functions.Function1<Import, Boolean>(){

                    public Boolean apply(Import it) {
                        boolean _isStealth = it.isStealth();
                        return !_isStealth;
                    }
                };
                List importsToCheck = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)importedMGLModel.getImports(), (Functions.Function1)_function));
                LinkedList alreadyVisitedMGLModel = CollectionLiterals.newLinkedList((Object[])new MGLModel[]{originalMGLModel, importedMGLModel});
                int i = 0;
                while (i < importsToCheck.size()) {
                    final MGLModel currentImportedMGL = CincoUtil.getImportedMGLModel((Import)((Import)importsToCheck.get(i)));
                    if (currentImportedMGL != null) {
                        Functions.Function1<MGLModel, Boolean> _function_1 = new Functions.Function1<MGLModel, Boolean>(){

                            public Boolean apply(MGLModel it) {
                                return MGLUtil.equalMGLModels((MGLModel)it, (MGLModel)currentImportedMGL);
                            }
                        };
                        boolean _exists = IterableExtensions.exists((Iterable)alreadyVisitedMGLModel, (Functions.Function1)_function_1);
                        if (_exists) {
                            String _fileName = GeneratorUtils.getInstance().getFileName(currentImportedMGL);
                            String _plus = "Cyclic imports detected at " + _fileName;
                            String _plus_1 = String.valueOf(_plus) + ".mgl";
                            this.error(_plus_1, (EStructuralFeature)MglPackage.Literals.IMPORT__IMPORT_URI);
                            return;
                        }
                        alreadyVisitedMGLModel.add(currentImportedMGL);
                        Functions.Function1<Import, Boolean> _function_2 = new Functions.Function1<Import, Boolean>(){

                            public Boolean apply(Import it) {
                                boolean _isStealth = it.isStealth();
                                return !_isStealth;
                            }
                        };
                        importsToCheck.addAll(IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)currentImportedMGL.getImports(), (Functions.Function1)_function_2)));
                    }
                    ++i;
                }
            }
        }
    }

    @Check
    public void checkExternalImportsPointToMGLs(Import imprt) {
        if (imprt.isExternal() && !imprt.getImportURI().endsWith(".mgl")) {
            this.error("Imports of external resources may only import MGLs", (EStructuralFeature)MglPackage.Literals.IMPORT__IMPORT_URI);
        }
    }

    @Check
    public void checkModelElementNameForNameClashes(final ModelElement me) {
        MGLModel mgl = MGLUtil.getMglModel((ModelElement)me);
        Functions.Function1<Import, Boolean> _function = new Functions.Function1<Import, Boolean>(){

            public Boolean apply(Import it) {
                boolean _isStealth = it.isStealth();
                return !_isStealth;
            }
        };
        Iterable imports = IterableExtensions.filter((Iterable)mgl.getImports(), (Functions.Function1)_function);
        Consumer<Import> _function_1 = new Consumer<Import>(){

            @Override
            public void accept(final Import imp) {
                Consumer<ModelElement> _function = new Consumer<ModelElement>(){

                    @Override
                    public void accept(ModelElement it) {
                        if (!MGLUtil.equalModelElement((Type)it, (Type)me) && Objects.equal((Object)it.getName(), (Object)me.getName())) {
                            String _name = imp.getName();
                            String _plus = "This name already exists in the imported MGL \"" + _name;
                            String _plus_1 = String.valueOf(_plus) + "\"";
                            MGLValidator.this.error(_plus_1, (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
                        }
                    }
                };
                MGLUtil.modelElements((MGLModel)CincoUtil.getImportedMGLModel((Import)imp), (boolean)true).forEach(_function);
            }
        };
        imports.forEach(_function_1);
    }

    @Check
    public void checkImportForNameClashes(final Import imprt) {
        boolean _not;
        boolean _isStealth = imprt.isStealth();
        boolean bl = _not = !_isStealth;
        if (_not) {
            EObject _eContainer = imprt.eContainer();
            MGLModel mgl = (MGLModel)_eContainer;
            Functions.Function1<Import, Boolean> _function = new Functions.Function1<Import, Boolean>(){

                public Boolean apply(Import it) {
                    boolean _isStealth = it.isStealth();
                    return !_isStealth;
                }
            };
            Iterable imports = IterableExtensions.filter((Iterable)mgl.getImports(), (Functions.Function1)_function);
            final MGLModel importedMGL = CincoUtil.getImportedMGLModel((Import)imprt);
            Consumer<Import> _function_1 = new Consumer<Import>(){

                @Override
                public void accept(final Import imp) {
                    if (imprt != imp) {
                        Consumer<ModelElement> _function = new Consumer<ModelElement>(){

                            @Override
                            public void accept(final ModelElement importedMe) {
                                Consumer<ModelElement> _function = new Consumer<ModelElement>(){

                                    @Override
                                    public void accept(ModelElement it) {
                                        String _name_1;
                                        String _name = it.getName();
                                        boolean _equals = Objects.equal((Object)_name, (Object)(_name_1 = importedMe.getName()));
                                        if (_equals) {
                                            String _name_2 = it.getName();
                                            String _plus = "The model element name \"" + _name_2;
                                            String _plus_1 = String.valueOf(_plus) + "\" leads to a name clash, as ";
                                            String _plus_2 = String.valueOf(_plus_1) + "it exists in the imported MGLs \"";
                                            String _name_3 = imp.getName();
                                            String _plus_3 = String.valueOf(_plus_2) + _name_3;
                                            String _plus_4 = String.valueOf(_plus_3) + "\" and \"";
                                            String _name_4 = imprt.getName();
                                            String _plus_5 = String.valueOf(_plus_4) + _name_4;
                                            String _plus_6 = String.valueOf(_plus_5) + "\".";
                                            MGLValidator.this.error(_plus_6, (EStructuralFeature)MglPackage.Literals.IMPORT__NAME);
                                        }
                                    }
                                };
                                MGLUtil.modelElements((MGLModel)importedMGL).forEach(_function);
                            }
                        };
                        MGLUtil.modelElements((MGLModel)CincoUtil.getImportedMGLModel((Import)imp), (boolean)true).forEach(_function);
                    }
                }
            };
            imports.forEach(_function_1);
        }
    }

    @Check
    public void checkDefaultValueOverrideScope(final DefaultValueOverride dvo) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        EObject _eContainer = dvo.eContainer();
        ModelElement me = (ModelElement)_eContainer;
        String _switchResult = null;
        boolean _matched = false;
        if (me instanceof GraphModel) {
            _matched = true;
            _switchResult = "Graph model";
        }
        if (!_matched && me instanceof NodeContainer) {
            _matched = true;
            _switchResult = "Container";
        }
        if (!_matched && me instanceof Node) {
            _matched = true;
            _switchResult = "Node";
        }
        if (!_matched && me instanceof Edge) {
            _matched = true;
            _switchResult = "Edge";
        }
        if (!_matched && me instanceof UserDefinedType) {
            _matched = true;
            _switchResult = "Type";
        }
        if (!_matched) {
            _switchResult = me.getClass().getSimpleName();
        }
        String meType = _switchResult;
        ModelElement _extends = MGLValidator.getExtends(me);
        boolean bl = _tripleEquals = _extends == null;
        if (_tripleEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(meType);
            _builder.append(" ");
            String _name = me.getName();
            _builder.append(_name);
            _builder.append(" does not extend other type.");
            this.error(_builder.toString(), (EObject)dvo, (EStructuralFeature)MglPackage.Literals.DEFAULT_VALUE_OVERRIDE__MODEL_ELEMENT);
            return;
        }
        PrimitiveAttribute _attribute = dvo.getAttribute();
        boolean bl2 = _tripleEquals_1 = _attribute == null;
        if (_tripleEquals_1) {
            return;
        }
        me = MGLValidator.getExtends(me);
        while (me != null) {
            Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

                public Boolean apply(Attribute it) {
                    String _name = it.getName();
                    String _name_1 = dvo.getAttribute().getName();
                    return Objects.equal((Object)_name, (Object)_name_1);
                }
            };
            boolean _exists = IterableExtensions.exists((Iterable)me.getAttributes(), (Functions.Function1)_function);
            if (_exists) {
                return;
            }
            me = MGLValidator.getExtends(me);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Couldn't resolve reference to PrimitiveAttribute '");
        String _name_1 = dvo.getAttribute().getName();
        _builder_1.append(_name_1);
        _builder_1.append("'.");
        this.error(_builder_1.toString(), (EObject)dvo, (EStructuralFeature)MglPackage.Literals.DEFAULT_VALUE_OVERRIDE__ATTRIBUTE);
    }

    @Check
    public void checkDefaultValueOverrideDuplicates(ModelElement element) {
        Functions.Function1<DefaultValueOverride, String> _function = new Functions.Function1<DefaultValueOverride, String>(){

            public String apply(DefaultValueOverride it) {
                return it.getAttribute().getName();
            }
        };
        List dvos = IterableExtensions.sortBy((Iterable)element.getDefaultValueOverrides(), (Functions.Function1)_function);
        DefaultValueOverride lastDvo = (DefaultValueOverride)IterableExtensions.head((Iterable)dvos);
        int _size = dvos.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(1, _size, true);
        for (Integer i : _doubleDotLessThan) {
            PrimitiveAttribute _attribute_1;
            boolean _tripleEquals;
            DefaultValueOverride currentDvo = (DefaultValueOverride)dvos.get(i);
            PrimitiveAttribute _attribute = currentDvo.getAttribute();
            boolean bl = _tripleEquals = _attribute == (_attribute_1 = lastDvo.getAttribute());
            if (_tripleEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Duplicate override of default value");
                this.error(_builder.toString(), (EObject)lastDvo, (EStructuralFeature)MglPackage.Literals.DEFAULT_VALUE_OVERRIDE__ATTRIBUTE);
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Duplicate override of default value");
                this.error(_builder_1.toString(), (EObject)currentDvo, (EStructuralFeature)MglPackage.Literals.DEFAULT_VALUE_OVERRIDE__ATTRIBUTE);
            }
            lastDvo = currentDvo;
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkMglUsage(MGLModel mgl) {
        IFile mglFile = this._workspaceExtension.getFile((EObject)mgl);
        String mglReltivePath = mglFile.getProjectRelativePath().toString();
        Functions.Function1<IFile, CincoProduct> _function = new Functions.Function1<IFile, CincoProduct>(){

            public CincoProduct apply(IFile it) {
                return (CincoProduct)MGLValidator.this._fileExtension.getContent(it, CincoProduct.class);
            }
        };
        Functions.Function1<CincoProduct, EList<MGLDescriptor>> _function_1 = new Functions.Function1<CincoProduct, EList<MGLDescriptor>>(){

            public EList<MGLDescriptor> apply(CincoProduct it) {
                return it.getMgls();
            }
        };
        Functions.Function1<MGLDescriptor, String> _function_2 = new Functions.Function1<MGLDescriptor, String>(){

            public String apply(MGLDescriptor it) {
                return it.getMglPath();
            }
        };
        boolean mglIsUsed = IterableExtensions.contains((Iterable)IterableExtensions.map((Iterable)IterableExtensions.flatMap((Iterable)ListExtensions.map((List)this._fileExtension.findFiles((IContainer)mglFile.getProject(), "cpd"), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Object)mglReltivePath);
        if (!mglIsUsed) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("This MGL unused. Add this MGL as \"");
            _builder.append(mglReltivePath);
            _builder.append("\" to a CPD.");
            this.warning(_builder.toString(), (EObject)mgl, (EStructuralFeature)MglPackage.Literals.MGL_MODEL__PACKAGE);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkGlobalModelElementUsage(MGLModel mgl) {
        Cache Cache2 = Cache.getInstance(mgl);
        try {
            EList _nodes = mgl.getNodes();
            for (Node node : _nodes) {
                if (node.isIsAbstract() && !Cache2.hasSubType((ModelElement)node)) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("The abstract ");
                    if (node instanceof NodeContainer) {
                        _builder.append("container");
                    } else {
                        _builder.append("node");
                    }
                    _builder.append(" \"");
                    String _name = node.getName();
                    _builder.append(_name);
                    _builder.append("\" is unused. It is never extended.");
                    this.warning(_builder.toString(), (EObject)node, (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
                    continue;
                }
                if (node.isIsAbstract() || Cache2.isContained(node)) continue;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("The ");
                if (node instanceof NodeContainer) {
                    _builder_1.append("container");
                } else {
                    _builder_1.append("node");
                }
                _builder_1.append(" \"");
                String _name_1 = node.getName();
                _builder_1.append(_name_1);
                _builder_1.append("\" is unused. It cannot be contained by any graph model or container.");
                this.warning(_builder_1.toString(), (EObject)node, (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
            }
            EList _edges = mgl.getEdges();
            for (Edge edge : _edges) {
                boolean isNotOutgoing;
                boolean _not;
                if (edge.isIsAbstract() && !Cache2.hasSubType((ModelElement)edge)) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("The abstract edge \"");
                    String _name_2 = edge.getName();
                    _builder_2.append(_name_2);
                    _builder_2.append("\" is unused. It is never extended.");
                    this.warning(_builder_2.toString(), (EObject)edge, (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
                    continue;
                }
                boolean _isIsAbstract = edge.isIsAbstract();
                boolean bl = _not = !_isIsAbstract;
                if (!_not) continue;
                boolean _isConnectedIncoming = Cache2.isConnectedIncoming(edge);
                boolean isNotIncoming = !_isConnectedIncoming;
                boolean _isConnectedOutgoing = Cache2.isConnectedOutgoing(edge);
                boolean bl2 = isNotOutgoing = !_isConnectedOutgoing;
                if (isNotIncoming && isNotOutgoing) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("The edge \"");
                    String _name_3 = edge.getName();
                    _builder_3.append(_name_3);
                    _builder_3.append("\" is unused. It never serves as an incoming or outgoing edge.");
                    this.warning(_builder_3.toString(), (EObject)edge, (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
                    continue;
                }
                if (isNotIncoming) {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("The edge \"");
                    String _name_4 = edge.getName();
                    _builder_4.append(_name_4);
                    _builder_4.append("\" is unused. It never serves as an incoming edge.");
                    this.warning(_builder_4.toString(), (EObject)edge, (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
                    continue;
                }
                if (!isNotOutgoing) continue;
                StringConcatenation _builder_5 = new StringConcatenation();
                _builder_5.append("The edge \"");
                String _name_5 = edge.getName();
                _builder_5.append(_name_5);
                _builder_5.append("\" is unused. It never serves as an outgoing edge.");
                this.warning(_builder_5.toString(), (EObject)edge, (EStructuralFeature)MglPackage.Literals.TYPE__NAME);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private ContainingElement getContainingSuperType(EObject modelElement) {
        if (modelElement instanceof Node) {
            return this._getContainingSuperType((Node)modelElement);
        }
        if (modelElement instanceof ContainingElement) {
            return this._getContainingSuperType((ContainingElement)modelElement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(modelElement).toString());
    }

    private static class Cache {
        @Extension
        private FileExtension _fileExtension = new FileExtension();
        @Extension
        private WorkspaceExtension _workspaceExtension = new WorkspaceExtension();
        private static Cache instance;
        private long timeStamp = System.currentTimeMillis();
        private List<MGLModel> mgls;
        private List<GraphModel> graphModels;
        private List<Node> nodesAndContainers;
        private List<Node> nodes;
        private List<NodeContainer> containers;
        private List<Edge> edges;
        private DirectedGraph<ModelElement> inheritanceGraph;
        private Set<Node> isContained;
        private Set<Edge> isConnectedIncoming;
        private Set<Edge> isConnectedOutgoing;

        public static Cache getInstance(MGLModel mgl) {
            if (instance == null || instance.isOutdated(mgl)) {
                Cache _cache;
                instance = _cache = new Cache(mgl);
            }
            return instance;
        }

        public Cache(MGLModel mgl) {
            try {
                DirectedGraph _directedGraph;
                IFile mglFile = this._workspaceExtension.getFile((EObject)mgl);
                final String mglReltivePath = mglFile.getProjectRelativePath().toString();
                final IProject project = mglFile.getProject();
                Functions.Function1<IFile, CincoProduct> _function = new Functions.Function1<IFile, CincoProduct>(){

                    public CincoProduct apply(IFile it) {
                        return (CincoProduct)_fileExtension.getContent(it, CincoProduct.class);
                    }
                };
                Functions.Function1<CincoProduct, List<String>> _function_1 = new Functions.Function1<CincoProduct, List<String>>(){

                    public List<String> apply(CincoProduct cpd) {
                        Functions.Function1<MGLDescriptor, String> _function = new Functions.Function1<MGLDescriptor, String>(){

                            public String apply(MGLDescriptor it) {
                                return it.getMglPath();
                            }
                        };
                        return ListExtensions.map((List)cpd.getMgls(), (Functions.Function1)_function);
                    }
                };
                Functions.Function1<List<String>, Boolean> _function_2 = new Functions.Function1<List<String>, Boolean>(){

                    public Boolean apply(List<String> it) {
                        return it.contains(mglReltivePath);
                    }
                };
                Functions.Function1<List<String>, List<MGLModel>> _function_3 = new Functions.Function1<List<String>, List<MGLModel>>(){

                    public List<MGLModel> apply(List<String> paths) {
                        Functions.Function1<String, MGLModel> _function = new Functions.Function1<String, MGLModel>(){

                            public MGLModel apply(String path) {
                                return (MGLModel)_fileExtension.getContent(project.getFile(path), MGLModel.class);
                            }
                        };
                        return ListExtensions.map(paths, (Functions.Function1)_function);
                    }
                };
                Functions.Function1<List<MGLModel>, Set<MGLModel>> _function_4 = new Functions.Function1<List<MGLModel>, Set<MGLModel>>(){

                    public Set<MGLModel> apply(List<MGLModel> mgls) {
                        return MGLUtil.prepareMglModels((Set)IterableExtensions.toSet(mgls));
                    }
                };
                this.mgls = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)ListExtensions.map((List)this._fileExtension.findFiles((IContainer)project, "cpd"), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4)));
                Functions.Function1<MGLModel, EList<GraphModel>> _function_5 = new Functions.Function1<MGLModel, EList<GraphModel>>(){

                    public EList<GraphModel> apply(MGLModel m) {
                        return m.getGraphModels();
                    }
                };
                this.graphModels = IterableExtensions.toList((Iterable)IterableExtensions.flatMap(this.mgls, (Functions.Function1)_function_5));
                Functions.Function1<MGLModel, EList<Node>> _function_6 = new Functions.Function1<MGLModel, EList<Node>>(){

                    public EList<Node> apply(MGLModel m) {
                        return m.getNodes();
                    }
                };
                this.nodesAndContainers = IterableExtensions.toList((Iterable)IterableExtensions.flatMap(this.mgls, (Functions.Function1)_function_6));
                this.nodes = IterableExtensions.toList((Iterable)IterableExtensions.reject(this.nodesAndContainers, NodeContainer.class));
                this.containers = IterableExtensions.toList((Iterable)Iterables.filter(this.nodesAndContainers, NodeContainer.class));
                Functions.Function1<MGLModel, EList<Edge>> _function_7 = new Functions.Function1<MGLModel, EList<Edge>>(){

                    public EList<Edge> apply(MGLModel m) {
                        return m.getEdges();
                    }
                };
                this.edges = IterableExtensions.toList((Iterable)IterableExtensions.flatMap(this.mgls, (Functions.Function1)_function_7));
                Functions.Function2<ModelElement, ModelElement, Boolean> _function_8 = new Functions.Function2<ModelElement, ModelElement, Boolean>(){

                    public Boolean apply(ModelElement l, ModelElement r) {
                        return Cache.modelElementEquals(l, r);
                    }
                };
                this.inheritanceGraph = _directedGraph = new DirectedGraph((Functions.Function2)_function_8);
                Iterable _plus = Iterables.concat(this.graphModels, this.nodes);
                Iterable _plus_1 = Iterables.concat((Iterable)_plus, this.containers);
                Iterable _plus_2 = Iterables.concat((Iterable)_plus_1, this.edges);
                for (ModelElement type : _plus_2) {
                    DirectedGraph.Node n = this.inheritanceGraph.addNode((Object)type);
                    ModelElement superType = MGLValidator.getExtends(type);
                    if (superType == null) continue;
                    n.addParent((Object)superType);
                }
                HashSet<Node> _hashSet = new HashSet<Node>();
                this.isContained = _hashSet;
                Iterable _plus_3 = Iterables.concat(this.graphModels, this.containers);
                for (EObject container : _plus_3) {
                    Functions.Function1<GraphicalElementContainment, Boolean> _function_9 = new Functions.Function1<GraphicalElementContainment, Boolean>(){

                        public Boolean apply(GraphicalElementContainment it) {
                            int _upperBound = it.getUpperBound();
                            return _upperBound == 0;
                        }
                    };
                    Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>> _function_10 = new Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>>(){

                        public EList<GraphicalModelElement> apply(GraphicalElementContainment it) {
                            return it.getTypes();
                        }
                    };
                    Functions.Function1<GraphicalModelElement, List<ModelElement>> _function_11 = new Functions.Function1<GraphicalModelElement, List<ModelElement>>(){

                        public List<ModelElement> apply(GraphicalModelElement it) {
                            return this.getSubTypes((ModelElement)it);
                        }
                    };
                    final Iterable mustNotContain = IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filter((Iterable)((ContainingElement)container).getContainableElements(), (Functions.Function1)_function_9), (Functions.Function1)_function_10), (Functions.Function1)_function_11);
                    Functions.Function1<GraphicalElementContainment, Boolean> _function_12 = new Functions.Function1<GraphicalElementContainment, Boolean>(){

                        public Boolean apply(GraphicalElementContainment it) {
                            int _upperBound = it.getUpperBound();
                            return _upperBound == 0;
                        }
                    };
                    Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>> _function_13 = new Functions.Function1<GraphicalElementContainment, EList<GraphicalModelElement>>(){

                        public EList<GraphicalModelElement> apply(GraphicalElementContainment it) {
                            return it.getTypes();
                        }
                    };
                    Functions.Function1<GraphicalModelElement, List<ModelElement>> _function_14 = new Functions.Function1<GraphicalModelElement, List<ModelElement>>(){

                        public List<ModelElement> apply(GraphicalModelElement it) {
                            return this.getSubTypes((ModelElement)it);
                        }
                    };
                    Functions.Function1<Node, Boolean> _function_15 = new Functions.Function1<Node, Boolean>(){

                        public Boolean apply(Node it) {
                            return IterableExtensions.contains((Iterable)mustNotContain, (Object)it);
                        }
                    };
                    Iterable canContain = IterableExtensions.reject((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.reject((Iterable)((ContainingElement)container).getContainableElements(), (Functions.Function1)_function_12), (Functions.Function1)_function_13), (Functions.Function1)_function_14), Node.class), (Functions.Function1)_function_15);
                    Iterables.addAll(this.isContained, (Iterable)canContain);
                }
                HashSet<Edge> _hashSet_1 = new HashSet<Edge>();
                this.isConnectedIncoming = _hashSet_1;
                HashSet<Edge> _hashSet_2 = new HashSet<Edge>();
                this.isConnectedOutgoing = _hashSet_2;
                for (Node node : this.nodesAndContainers) {
                    Functions.Function1<IncomingEdgeElementConnection, Boolean> _function_9 = new Functions.Function1<IncomingEdgeElementConnection, Boolean>(){

                        public Boolean apply(IncomingEdgeElementConnection it) {
                            int _upperBound = it.getUpperBound();
                            return _upperBound == 0;
                        }
                    };
                    Functions.Function1<IncomingEdgeElementConnection, EList<Edge>> _function_10 = new Functions.Function1<IncomingEdgeElementConnection, EList<Edge>>(){

                        public EList<Edge> apply(IncomingEdgeElementConnection it) {
                            return it.getConnectingEdges();
                        }
                    };
                    Functions.Function1<Edge, List<ModelElement>> _function_11 = new Functions.Function1<Edge, List<ModelElement>>(){

                        public List<ModelElement> apply(Edge it) {
                            return this.getSubTypes((ModelElement)it);
                        }
                    };
                    final Iterable mustNotConnectIncoming = IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filter((Iterable)node.getIncomingEdgeConnections(), (Functions.Function1)_function_9), (Functions.Function1)_function_10), (Functions.Function1)_function_11);
                    Functions.Function1<IncomingEdgeElementConnection, Boolean> _function_12 = new Functions.Function1<IncomingEdgeElementConnection, Boolean>(){

                        public Boolean apply(IncomingEdgeElementConnection it) {
                            int _upperBound = it.getUpperBound();
                            return _upperBound == 0;
                        }
                    };
                    Functions.Function1<IncomingEdgeElementConnection, EList<Edge>> _function_13 = new Functions.Function1<IncomingEdgeElementConnection, EList<Edge>>(){

                        public EList<Edge> apply(IncomingEdgeElementConnection it) {
                            return it.getConnectingEdges();
                        }
                    };
                    Functions.Function1<Edge, List<ModelElement>> _function_14 = new Functions.Function1<Edge, List<ModelElement>>(){

                        public List<ModelElement> apply(Edge it) {
                            return this.getSubTypes((ModelElement)it);
                        }
                    };
                    Functions.Function1<Edge, Boolean> _function_15 = new Functions.Function1<Edge, Boolean>(){

                        public Boolean apply(Edge it) {
                            return IterableExtensions.contains((Iterable)mustNotConnectIncoming, (Object)it);
                        }
                    };
                    Iterable canConnectIncoming = IterableExtensions.reject((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.reject((Iterable)node.getIncomingEdgeConnections(), (Functions.Function1)_function_12), (Functions.Function1)_function_13), (Functions.Function1)_function_14), Edge.class), (Functions.Function1)_function_15);
                    Iterables.addAll(this.isConnectedIncoming, (Iterable)canConnectIncoming);
                    Functions.Function1<OutgoingEdgeElementConnection, Boolean> _function_16 = new Functions.Function1<OutgoingEdgeElementConnection, Boolean>(){

                        public Boolean apply(OutgoingEdgeElementConnection it) {
                            int _upperBound = it.getUpperBound();
                            return _upperBound == 0;
                        }
                    };
                    Functions.Function1<OutgoingEdgeElementConnection, EList<Edge>> _function_17 = new Functions.Function1<OutgoingEdgeElementConnection, EList<Edge>>(){

                        public EList<Edge> apply(OutgoingEdgeElementConnection it) {
                            return it.getConnectingEdges();
                        }
                    };
                    Functions.Function1<Edge, List<ModelElement>> _function_18 = new Functions.Function1<Edge, List<ModelElement>>(){

                        public List<ModelElement> apply(Edge it) {
                            return this.getSubTypes((ModelElement)it);
                        }
                    };
                    final Iterable mustNotConnectOutgoing = IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filter((Iterable)node.getOutgoingEdgeConnections(), (Functions.Function1)_function_16), (Functions.Function1)_function_17), (Functions.Function1)_function_18);
                    Functions.Function1<OutgoingEdgeElementConnection, Boolean> _function_19 = new Functions.Function1<OutgoingEdgeElementConnection, Boolean>(){

                        public Boolean apply(OutgoingEdgeElementConnection it) {
                            int _upperBound = it.getUpperBound();
                            return _upperBound == 0;
                        }
                    };
                    Functions.Function1<OutgoingEdgeElementConnection, EList<Edge>> _function_20 = new Functions.Function1<OutgoingEdgeElementConnection, EList<Edge>>(){

                        public EList<Edge> apply(OutgoingEdgeElementConnection it) {
                            return it.getConnectingEdges();
                        }
                    };
                    Functions.Function1<Edge, List<ModelElement>> _function_21 = new Functions.Function1<Edge, List<ModelElement>>(){

                        public List<ModelElement> apply(Edge it) {
                            return this.getSubTypes((ModelElement)it);
                        }
                    };
                    Functions.Function1<Edge, Boolean> _function_22 = new Functions.Function1<Edge, Boolean>(){

                        public Boolean apply(Edge it) {
                            return IterableExtensions.contains((Iterable)mustNotConnectOutgoing, (Object)it);
                        }
                    };
                    Iterable canConnectOutgoing = IterableExtensions.reject((Iterable)Iterables.filter((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.reject((Iterable)node.getOutgoingEdgeConnections(), (Functions.Function1)_function_19), (Functions.Function1)_function_20), (Functions.Function1)_function_21), Edge.class), (Functions.Function1)_function_22);
                    Iterables.addAll(this.isConnectedOutgoing, (Iterable)canConnectOutgoing);
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                    instance = null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }

        public static boolean modelElementEquals(ModelElement l, ModelElement r) {
            return Objects.equal((Object)l.getName(), (Object)r.getName()) && Objects.equal((Object)((MGLModel)l.eContainer()).getPackage(), (Object)((MGLModel)l.eContainer()).getPackage());
        }

        public List<ModelElement> getSubTypes(ModelElement me) {
            Functions.Function1<DirectedGraph.Node<ModelElement>, ModelElement> _function = new Functions.Function1<DirectedGraph.Node<ModelElement>, ModelElement>(){

                public ModelElement apply(DirectedGraph.Node<ModelElement> it) {
                    return (ModelElement)it.getContent();
                }
            };
            return ListExtensions.map((List)this.inheritanceGraph.getNode((Object)me).getDescendantsAndSelf(), (Functions.Function1)_function);
        }

        public boolean hasSubType(ModelElement me) {
            boolean _isEmpty = this.inheritanceGraph.getNode((Object)me).getChildren().isEmpty();
            return !_isEmpty;
        }

        public boolean isContained(final Node node) {
            Functions.Function1<Node, Boolean> _function = new Functions.Function1<Node, Boolean>(){

                public Boolean apply(Node other) {
                    return Cache.modelElementEquals((ModelElement)node, (ModelElement)other);
                }
            };
            return IterableExtensions.exists(this.isContained, (Functions.Function1)_function);
        }

        public boolean isConnectedIncoming(final Edge edge) {
            Functions.Function1<Edge, Boolean> _function = new Functions.Function1<Edge, Boolean>(){

                public Boolean apply(Edge other) {
                    return Cache.modelElementEquals((ModelElement)edge, (ModelElement)other);
                }
            };
            return IterableExtensions.exists(this.isConnectedIncoming, (Functions.Function1)_function);
        }

        public boolean isConnectedOutgoing(final Edge edge) {
            Functions.Function1<Edge, Boolean> _function = new Functions.Function1<Edge, Boolean>(){

                public Boolean apply(Edge other) {
                    return Cache.modelElementEquals((ModelElement)edge, (ModelElement)other);
                }
            };
            return IterableExtensions.exists(this.isConnectedOutgoing, (Functions.Function1)_function);
        }

        public boolean isOutdated(MGLModel mgl) {
            IProject project = this._workspaceExtension.getFile((EObject)mgl).getProject();
            ArrayList cpds = this._fileExtension.findFiles((IContainer)project, "cpd");
            ArrayList mgls = this._fileExtension.findFiles((IContainer)project, "mgl");
            Functions.Function1<IFile, Boolean> _function = new Functions.Function1<IFile, Boolean>(){

                public Boolean apply(IFile it) {
                    long _lastModified = _fileExtension.lastModified(it);
                    return _lastModified > timeStamp;
                }
            };
            return IterableExtensions.exists((Iterable)Iterables.concat((Iterable)cpds, (Iterable)mgls), (Functions.Function1)_function);
        }
    }
}

