/*
 * Decompiled with CFR 0.152.
 */
package de.jabc.cinco.meta.core.mgl.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import de.jabc.cinco.meta.core.mgl.generator.GenModelCreator;
import de.jabc.cinco.meta.core.mgl.generator.GenModelDescription;
import de.jabc.cinco.meta.core.mgl.generator.MGLAdaptersGenerator;
import de.jabc.cinco.meta.core.mgl.generator.MGLEcoreGenerator;
import de.jabc.cinco.meta.core.mgl.generator.MGLFactoryGenerator;
import de.jabc.cinco.meta.core.mgl.generator.elements.ElementEClasses;
import de.jabc.cinco.meta.core.pluginregistry.IMGLMetaPlugin;
import de.jabc.cinco.meta.core.pluginregistry.PluginRegistry;
import de.jabc.cinco.meta.core.utils.GeneratorHelper;
import de.jabc.cinco.meta.core.utils.MGLUtil;
import de.jabc.cinco.meta.core.utils.URIHandler;
import de.jabc.cinco.meta.core.utils.generator.GeneratorUtils;
import de.jabc.cinco.meta.core.utils.projects.ProjectCreator;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import mgl.Annotatable;
import mgl.Annotation;
import mgl.MGLModel;
import mgl.Type;
import mgl.UserDefinedType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import productDefinition.CincoProduct;

public class MGLGenerator {
    private final HashMap<EModelElement, MGLModel> packageMGLModelMap = CollectionLiterals.newHashMap();

    public synchronized void doGenerateEcoreModels(List<MGLModel> allMGLModels, Set<MGLModel> generateMGLModels, Map<MGLModel, Pair<Resource, Resource>> importedExternalMGLs, CincoProduct cp) {
        Set preparedModels = MGLUtil.prepareMglModels(generateMGLModels);
        GeneratorUtils _instance = GeneratorUtils.getInstance();
        _instance.allMGLs = preparedModels;
        final MGLEcoreGenerator mglEcoreGenerator = new MGLEcoreGenerator();
        final HashMap newImportedExternalMGLs = new HashMap();
        Consumer<Map.Entry<MGLModel, Pair<Resource, Resource>>> _function = new Consumer<Map.Entry<MGLModel, Pair<Resource, Resource>>>(){

            @Override
            public void accept(Map.Entry<MGLModel, Pair<Resource, Resource>> iem) {
                newImportedExternalMGLs.put(iem.getKey(), (Resource)iem.getValue().getKey());
            }
        };
        importedExternalMGLs.entrySet().forEach(_function);
        EPackage rootEPackage = mglEcoreGenerator.generateEcoreModels((Iterable)preparedModels, newImportedExternalMGLs, this.packageMGLModelMap, cp);
        Consumer<MGLModel> _function_1 = new Consumer<MGLModel>(){

            @Override
            public void accept(MGLModel it) {
                List _modelElements = MGLUtil.modelElements((MGLModel)it);
                Functions.Function1<Type, Boolean> _function = new Functions.Function1<Type, Boolean>(){

                    public Boolean apply(Type type) {
                        return type instanceof UserDefinedType;
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)it.getTypes(), (Functions.Function1)_function);
                final List mglModelElement = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)_modelElements, (Iterable)_filter));
                Functions.Function1<ElementEClasses, Boolean> _function_1 = new Functions.Function1<ElementEClasses, Boolean>(){

                    public Boolean apply(ElementEClasses elementEClass) {
                        return mglModelElement.contains(elementEClass.getModelElement());
                    }
                };
                new MGLFactoryGenerator().generateFactory(it, IterableExtensions.filter((Iterable)mglEcoreGenerator.allElementEClasses, (Functions.Function1)_function_1));
                new MGLAdaptersGenerator().generateAdapters(it);
            }
        };
        generateMGLModels.forEach(_function_1);
        this.saveEcoreModel(rootEPackage, cp);
        Functions.Function1<Map.Entry<MGLModel, Pair<Resource, Resource>>, Resource> _function_2 = new Functions.Function1<Map.Entry<MGLModel, Pair<Resource, Resource>>, Resource>(){

            public Resource apply(Map.Entry<MGLModel, Pair<Resource, Resource>> it) {
                return (Resource)it.getValue().getValue();
            }
        };
        List externalGenmodels = IterableExtensions.toList((Iterable)IterableExtensions.map(importedExternalMGLs.entrySet(), (Functions.Function1)_function_2));
        this.generateGenModelCode(new GenModelDescription(rootEPackage, cp, externalGenmodels));
        MGLGenerator.generateMGLMetaPlugins(allMGLModels, IterableExtensions.toList(generateMGLModels), cp, rootEPackage);
    }

    public void retrievePersistedImportedExternalMGLEClasses(Set<MGLModel> importedExternalMGLs) {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI uri = URI.createURI((String)"test");
            Resource resource = resourceSet.createResource(uri);
            resource.load(null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void generateGenModelCode(GenModelDescription it) {
        Functions.Function1<Resource, Iterable<GenPackage>> _function = new Functions.Function1<Resource, Iterable<GenPackage>>(){

            public Iterable<GenPackage> apply(Resource it) {
                return Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)it.getAllContents()), GenPackage.class);
            }
        };
        it.setGenModel(this.generateGenModel(it.getModel(), it.getEcorePath(), it.getEPackage(), it.getProjectName(), it.getProjectID(), (IPath)it.getProjectPath(), IterableExtensions.toList((Iterable)IterableExtensions.flatMap(it.getExternalGenmodels(), (Functions.Function1)_function))));
        this.saveGenModel(it.getGenModel(), it.getModel());
        GeneratorHelper.generateGenModelCode((GenModel)it.getGenModel());
    }

    public void saveEcoreModel(EPackage ePackage, CincoProduct cp) {
        try {
            EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
            IPath _fullPath = ProjectCreator.getProject((Resource)cp.eResource()).getFullPath();
            String _name = cp.getName();
            String _plus = "/src-gen/model/" + _name;
            String _plus_1 = String.valueOf(_plus) + ".ecore";
            IPath outPath = _fullPath.append(_plus_1);
            URI uri = URI.createURI((String)outPath.toString());
            Resource modelResource = cp.eResource();
            ResourceSet ePackageResourceSet = modelResource.getResourceSet();
            if (ePackageResourceSet == null) {
                ResourceSetImpl _resourceSetImpl = new ResourceSetImpl();
                ePackageResourceSet = _resourceSetImpl;
            }
            Resource ePackageResource = ePackageResourceSet.createResource(uri);
            EList _contents = ePackageResource.getContents();
            _contents.add((Object)ePackage);
            HashMap<String, URIHandler> optionMap = new HashMap<String, URIHandler>();
            URIHandler _uRIHandler = new URIHandler(ePackage);
            optionMap.put("URI_HANDLER", _uRIHandler);
            ePackageResource.save(optionMap);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void saveGenModel(GenModel genModel, CincoProduct model) {
        try {
            IPath _fullPath = ProjectCreator.getProject((Resource)model.eResource()).getFullPath();
            String _name = model.getName();
            String _plus = "/src-gen/model/" + _name;
            String _plus_1 = String.valueOf(_plus) + ".genmodel";
            IPath outPath = _fullPath.append(_plus_1);
            URI uri = URI.createURI((String)outPath.toString());
            Resource genModelResource = model.eResource().getResourceSet().createResource(uri);
            genModelResource.getContents().add((Object)genModel);
            genModelResource.save(null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void generateMGLMetaPlugins(final List<MGLModel> allMGLs, final List<MGLModel> generatedMGLs, final CincoProduct cpd, final EPackage rootEPackage) {
        HashMap mglMetaPluginGenerators = PluginRegistry.getInstance().getPluginGenerators();
        if (mglMetaPluginGenerators == null || mglMetaPluginGenerators.isEmpty()) {
            return;
        }
        Functions.Function1<MGLModel, List<Annotation>> _function = new Functions.Function1<MGLModel, List<Annotation>>(){

            public List<Annotation> apply(MGLModel it) {
                return IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)it.eAllContents(), Annotation.class));
            }
        };
        final Iterable allAnnotations = IterableExtensions.flatMap(allMGLs, (Functions.Function1)_function);
        final IProject project = new ResourceExtension().getProject(cpd.eResource());
        Functions.Function1<MGLModel, EPackage> _function_1 = new Functions.Function1<MGLModel, EPackage>(){

            public EPackage apply(final MGLModel mgl) {
                Functions.Function1<EPackage, Boolean> _function = new Functions.Function1<EPackage, Boolean>(){

                    public Boolean apply(EPackage it) {
                        String _nsURI = it.getNsURI();
                        String _nsURI_1 = MGLUtil.nsURI((Annotatable)mgl);
                        return Objects.equal((Object)_nsURI, (Object)_nsURI_1);
                    }
                };
                return (EPackage)IterableExtensions.findFirst((Iterable)rootEPackage.getESubpackages(), (Functions.Function1)_function);
            }
        };
        final Map ePackages = IterableExtensions.toInvertedMap(generatedMGLs, (Functions.Function1)_function_1);
        Comparator<Map.Entry<String, IMGLMetaPlugin>> _function_2 = new Comparator<Map.Entry<String, IMGLMetaPlugin>>(){

            @Override
            public int compare(Map.Entry<String, IMGLMetaPlugin> l, Map.Entry<String, IMGLMetaPlugin> r) {
                int _comparePriorityTo = l.getValue().comparePriorityTo(r.getValue());
                int priorityDiff = -_comparePriorityTo;
                if (priorityDiff == 0) {
                    return l.getKey().compareToIgnoreCase(r.getKey());
                }
                return priorityDiff;
            }
        };
        Consumer<Map.Entry<String, IMGLMetaPlugin>> _function_3 = new Consumer<Map.Entry<String, IMGLMetaPlugin>>(){

            @Override
            public void accept(Map.Entry<String, IMGLMetaPlugin> entry) {
                boolean _not;
                final String mglMetaPluginName = entry.getKey();
                IMGLMetaPlugin mglMetaPlugin = entry.getValue();
                Functions.Function1<Annotation, Boolean> _function = new Functions.Function1<Annotation, Boolean>(){

                    public Boolean apply(Annotation annotation) {
                        String _name = annotation.getName();
                        return Objects.equal((Object)mglMetaPluginName, (Object)_name);
                    }
                };
                List relatedAnnotations = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)allAnnotations, (Functions.Function1)_function));
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)relatedAnnotations);
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    int _mGLMetaPluginPriority = mglMetaPlugin.getMGLMetaPluginPriority();
                    String _plus = "Executing MGL meta plugin: " + mglMetaPluginName + " (Priority: " + Integer.valueOf(_mGLMetaPluginPriority);
                    String _plus_1 = String.valueOf(_plus) + ")";
                    System.out.println(_plus_1);
                    mglMetaPlugin.executeMGLMetaPlugin(relatedAnnotations, generatedMGLs, allMGLs, cpd, project, ePackages);
                }
            }
        };
        IterableExtensions.sortWith(mglMetaPluginGenerators.entrySet(), (Comparator)_function_2).forEach(_function_3);
    }

    public GenModel generateGenModel(CincoProduct model, String ecorePath, EPackage ePackage, String projectName, String projectID, IPath projectPath, List<GenPackage> externalGenPackages) {
        try {
            Path _path = new Path(ecorePath);
            GenModel genModel = GenModelCreator.createGenModel((IPath)_path, ePackage, projectName, projectID, projectPath);
            Resource genResource = ePackage.eResource().getResourceSet().createResource(URI.createURI((String)"platform:/plugin/de.jabc.cinco.meta.core.mgl.model/model/GraphModel.genmodel"));
            genResource.load(null);
            EObject _get = (EObject)genResource.getContents().get(0);
            GenModel graphModelGenModel = (GenModel)_get;
            EList _usedGenPackages = genModel.getUsedGenPackages();
            EList _genPackages = graphModelGenModel.getGenPackages();
            Iterables.addAll((Collection)_usedGenPackages, (Iterable)_genPackages);
            genModel.getUsedGenPackages().addAll(externalGenPackages);
            genModel.setOperationReflection(true);
            EList _genPackages_1 = genModel.getGenPackages();
            for (GenPackage genPackage : _genPackages_1) {
                genPackage.setBasePackage("info.scce.cinco.product");
                EList _nestedGenPackages = genPackage.getNestedGenPackages();
                for (GenPackage nestedGenPackage : _nestedGenPackages) {
                    nestedGenPackage.setBasePackage(this.packageMGLModelMap.get(nestedGenPackage.getEcoreModelElement()).getPackage());
                }
            }
            return genModel;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

